/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.datalistener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.crafting.CustomRecipe;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

public class CrafterRecipeListener
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataPackRegistries dataPackRegistries;

    public CrafterRecipeListener(@NotNull DataPackRegistries dataPackRegistries) {
        super(GSON, "crafterrecipes");
        this.dataPackRegistries = dataPackRegistries;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> object, @NotNull IResourceManager resourceManagerIn, @NotNull IProfiler profilerIn) {
        Log.getLogger().info("Beginning load of custom recipes for colony workers");
        CustomRecipeManager recipeManager = CustomRecipeManager.getInstance();
        recipeManager.reset();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            ResourceLocation key = entry.getKey();
            try {
                JsonObject recipeJson = entry.getValue().getAsJsonObject();
                switch (JSONUtils.func_151219_a((JsonObject)recipeJson, (String)"type", (String)"")) {
                    case "recipe": 
                    case "recipe-multi-out": {
                        recipeManager.addRecipe(CustomRecipe.parse(key, recipeJson));
                        break;
                    }
                    case "remove": {
                        ResourceLocation toRemove = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)recipeJson, (String)"recipe-id-to-remove", (String)""));
                        recipeManager.removeRecipe(toRemove);
                    }
                }
            }
            catch (JsonParseException e) {
                Log.getLogger().error("Error parsing crafterrecipe " + key.toString(), (Throwable)e);
            }
        }
        recipeManager.buildLootData(this.dataPackRegistries.func_240965_c_());
        int totalRecipes = recipeManager.getAllRecipes().values().stream().mapToInt(Map::size).sum();
        Log.getLogger().info("Loaded " + totalRecipes + " recipes for " + recipeManager.getAllRecipes().size() + " crafters");
        IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().invalidateRecipes(this.dataPackRegistries.func_240967_e_());
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayerEntity player : server.func_184103_al().func_181057_v()) {
                recipeManager.sendCustomRecipeManagerPackets(player);
            }
        }
    }
}

